/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.ActivityCreator;
import com.twilio.rest.taskrouter.v1.workspace.ActivityDeleter;
import com.twilio.rest.taskrouter.v1.workspace.ActivityFetcher;
import com.twilio.rest.taskrouter.v1.workspace.ActivityReader;
import com.twilio.rest.taskrouter.v1.workspace.ActivityUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Activity
extends Resource {
    private static final long serialVersionUID = 20275383236164L;
    private final String accountSid;
    private final Boolean available;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static ActivityCreator creator(String pathWorkspaceSid, String friendlyName) {
        return new ActivityCreator(pathWorkspaceSid, friendlyName);
    }

    public static ActivityDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new ActivityDeleter(pathWorkspaceSid, pathSid);
    }

    public static ActivityFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new ActivityFetcher(pathWorkspaceSid, pathSid);
    }

    public static ActivityReader reader(String pathWorkspaceSid) {
        return new ActivityReader(pathWorkspaceSid);
    }

    public static ActivityUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new ActivityUpdater(pathWorkspaceSid, pathSid);
    }

    public static Activity fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Activity fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Activity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Activity(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="available") Boolean available, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.available = available;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity other = (Activity)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.available, other.available) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.available, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.workspaceSid, this.url, this.links);
    }

    public String toString() {
        return "Activity(accountSid=" + this.getAccountSid() + ", available=" + this.getAvailable() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", sid=" + this.getSid() + ", workspaceSid=" + this.getWorkspaceSid() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

