/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.synclist;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.synclist.SyncListItem;

public class SyncListItemFetcher
extends Fetcher<SyncListItem> {
    private String pathServiceSid;
    private String pathListSid;
    private Integer pathIndex;

    public SyncListItemFetcher(String pathServiceSid, String pathListSid, Integer pathIndex) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
        this.pathIndex = pathIndex;
    }

    @Override
    public SyncListItem fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Lists/{ListSid}/Items/{Index}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ListSid}", this.pathListSid.toString());
        path = path.replace("{Index}", this.pathIndex.toString());
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListItem fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncListItem.fromJson(response.getStream(), client.getObjectMapper());
    }
}

