/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.sim;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.sim.SimIpAddress;

public class SimIpAddressReader
extends Reader<SimIpAddress> {
    private String pathSimSid;
    private Integer pageSize;

    public SimIpAddressReader(String pathSimSid) {
        this.pathSimSid = pathSimSid;
    }

    public SimIpAddressReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SimIpAddress> read(TwilioRestClient client) {
        return new ResourceSet<SimIpAddress>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SimIpAddress> firstPage(TwilioRestClient client) {
        String path = "/v1/Sims/{SimSid}/IpAddresses";
        path = path.replace("{SimSid}", this.pathSimSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SimIpAddress> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SimIpAddress read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("ip_addresses", response.getContent(), SimIpAddress.class, client.getObjectMapper());
    }

    @Override
    public Page<SimIpAddress> previousPage(Page<SimIpAddress> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SimIpAddress> nextPage(Page<SimIpAddress> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SimIpAddress> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

