/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.sim.SimIpAddressReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimIpAddress
extends Resource {
    private static final long serialVersionUID = 180616107351268L;
    private final String ipAddress;
    private final IpAddressVersion ipAddressVersion;

    public static SimIpAddressReader reader(String pathSimSid) {
        return new SimIpAddressReader(pathSimSid);
    }

    public static SimIpAddress fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SimIpAddress.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SimIpAddress fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SimIpAddress.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SimIpAddress(@JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="ip_address_version") IpAddressVersion ipAddressVersion) {
        this.ipAddress = ipAddress;
        this.ipAddressVersion = ipAddressVersion;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final IpAddressVersion getIpAddressVersion() {
        return this.ipAddressVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimIpAddress other = (SimIpAddress)o;
        return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals((Object)this.ipAddressVersion, (Object)other.ipAddressVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipAddress, this.ipAddressVersion});
    }

    public String toString() {
        return "SimIpAddress(ipAddress=" + this.getIpAddress() + ", ipAddressVersion=" + (Object)((Object)this.getIpAddressVersion()) + ")";
    }

    public static enum IpAddressVersion {
        IPV4("IPv4"),
        IPV6("IPv6");

        private final String value;

        private IpAddressVersion(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static IpAddressVersion forValue(String value) {
            return (IpAddressVersion)Promoter.enumFromString((String)value, (Enum[])IpAddressVersion.values());
        }
    }
}

