/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.SmsCommand;
import java.net.URI;

public class SmsCommandCreator
extends Creator<SmsCommand> {
    private String sim;
    private String payload;
    private HttpMethod callbackMethod;
    private URI callbackUrl;

    public SmsCommandCreator(String sim, String payload) {
        this.sim = sim;
        this.payload = payload;
    }

    public SmsCommandCreator setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public SmsCommandCreator setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public SmsCommandCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public SmsCommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public SmsCommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    @Override
    public SmsCommand create(TwilioRestClient client) {
        String path = "/v1/SmsCommands";
        path = path.replace("{Sim}", this.sim.toString());
        path = path.replace("{Payload}", this.payload.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SmsCommand creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SmsCommand.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sim != null) {
            request.addPostParam("Sim", this.sim);
        }
        if (this.payload != null) {
            request.addPostParam("Payload", this.payload);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
    }
}

