/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Sim;

public class SimCreator
extends Creator<Sim> {
    private String iccid;
    private String registrationCode;

    public SimCreator(String iccid, String registrationCode) {
        this.iccid = iccid;
        this.registrationCode = registrationCode;
    }

    public SimCreator setIccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    public SimCreator setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
        return this;
    }

    @Override
    public Sim create(TwilioRestClient client) {
        String path = "/v1/Sims";
        path = path.replace("{Iccid}", this.iccid.toString());
        path = path.replace("{RegistrationCode}", this.registrationCode.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sim creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Sim.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.iccid != null) {
            request.addPostParam("Iccid", this.iccid);
        }
        if (this.registrationCode != null) {
            request.addPostParam("RegistrationCode", this.registrationCode);
        }
    }
}

