/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.SimCreator;
import com.twilio.rest.supersim.v1.SimFetcher;
import com.twilio.rest.supersim.v1.SimReader;
import com.twilio.rest.supersim.v1.SimUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sim
extends Resource {
    private static final long serialVersionUID = 28875728882839L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String iccid;
    private final Status status;
    private final String fleetSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static SimCreator creator(String iccid, String registrationCode) {
        return new SimCreator(iccid, registrationCode);
    }

    public static SimFetcher fetcher(String pathSid) {
        return new SimFetcher(pathSid);
    }

    public static SimReader reader() {
        return new SimReader();
    }

    public static SimUpdater updater(String pathSid) {
        return new SimUpdater(pathSid);
    }

    public static Sim fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sim.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sim fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sim.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sim(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="iccid") String iccid, @JsonProperty(value="status") Status status, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.iccid = iccid;
        this.status = status;
        this.fleetSid = fleetSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIccid() {
        return this.iccid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sim other = (Sim)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.iccid, other.iccid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.uniqueName, this.accountSid, this.iccid, this.status, this.fleetSid, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return "Sim(sid=" + this.getSid() + ", uniqueName=" + this.getUniqueName() + ", accountSid=" + this.getAccountSid() + ", iccid=" + this.getIccid() + ", status=" + (Object)((Object)this.getStatus()) + ", fleetSid=" + this.getFleetSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        NEW("new"),
        READY("ready"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        SCHEDULED("scheduled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum StatusUpdate {
        READY("ready"),
        ACTIVE("active"),
        INACTIVE("inactive");

        private final String value;

        private StatusUpdate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StatusUpdate forValue(String value) {
            return (StatusUpdate)Promoter.enumFromString((String)value, (Enum[])StatusUpdate.values());
        }
    }
}

