/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Variable;

public class VariableFetcher
extends Fetcher<Variable> {
    private String pathServiceSid;
    private String pathEnvironmentSid;
    private String pathSid;

    public VariableFetcher(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
        this.pathSid = pathSid;
    }

    @Override
    public Variable fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Environments/{EnvironmentSid}/Variables/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{EnvironmentSid}", this.pathEnvironmentSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Variable fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Variable.fromJson(response.getStream(), client.getObjectMapper());
    }
}

