/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Deployment;

public class DeploymentCreator
extends Creator<Deployment> {
    private String pathServiceSid;
    private String pathEnvironmentSid;
    private String buildSid;

    public DeploymentCreator(String pathServiceSid, String pathEnvironmentSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
    }

    public DeploymentCreator setBuildSid(String buildSid) {
        this.buildSid = buildSid;
        return this;
    }

    @Override
    public Deployment create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Environments/{EnvironmentSid}/Deployments";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{EnvironmentSid}", this.pathEnvironmentSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deployment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Deployment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.buildSid != null) {
            request.addPostParam("BuildSid", this.buildSid);
        }
    }
}

