/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.routes.v2.PhoneNumber;

public class PhoneNumberFetcher
extends Fetcher<PhoneNumber> {
    private String pathPhoneNumber;

    public PhoneNumberFetcher(String pathPhoneNumber) {
        this.pathPhoneNumber = pathPhoneNumber;
    }

    @Override
    public PhoneNumber fetch(TwilioRestClient client) {
        String path = "/v2/PhoneNumbers/{PhoneNumber}";
        path = path.replace("{PhoneNumber}", this.pathPhoneNumber.toString());
        Request request = new Request(HttpMethod.GET, Domains.ROUTES.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }
}

