/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewmessaging.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewmessaging.v1.Message;

public class MessageCreator
extends Creator<Message> {
    private Message.CreateMessagesRequest createMessagesRequest;

    public MessageCreator(Message.CreateMessagesRequest createMessagesRequest) {
        this.createMessagesRequest = createMessagesRequest;
    }

    public MessageCreator setCreateMessagesRequest(Message.CreateMessagesRequest createMessagesRequest) {
        this.createMessagesRequest = createMessagesRequest;
        return this;
    }

    @Override
    public Message create(TwilioRestClient client) {
        String path = "/v1/Messages";
        path = path.replace("{CreateMessagesRequest}", this.createMessagesRequest.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEWMESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.JSON);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request, TwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.createMessagesRequest != null) {
            request.setBody(Message.toJson(this.createMessagesRequest, objectMapper));
        }
    }
}

