/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless.sim;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.sim.Usage;

public class UsageFetcher
extends Fetcher<Usage> {
    private String pathSimSid;
    private String end;
    private String start;

    public UsageFetcher(String pathSimSid) {
        this.pathSimSid = pathSimSid;
    }

    public UsageFetcher setEnd(String end) {
        this.end = end;
        return this;
    }

    public UsageFetcher setStart(String start) {
        this.start = start;
        return this;
    }

    @Override
    public Usage fetch(TwilioRestClient client) {
        String path = "/wireless/Sims/{SimSid}/Usage";
        path = path.replace("{SimSid}", this.pathSimSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Usage fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Usage.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.end != null) {
            request.addQueryParam("End", this.end);
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start);
        }
    }
}

