/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.synclist;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.synclist.SyncListItem;

public class SyncListItemDeleter
extends Deleter<SyncListItem> {
    private String pathServiceSid;
    private String pathListSid;
    private Integer pathIndex;
    private String ifMatch;

    public SyncListItemDeleter(String pathServiceSid, String pathListSid, Integer pathIndex) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
        this.pathIndex = pathIndex;
    }

    public SyncListItemDeleter setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Lists/{ListSid}/Items/{Index}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ListSid}", this.pathListSid.toString());
        path = path.replace("{Index}", this.pathIndex.toString());
        Request request = new Request(HttpMethod.DELETE, Domains.PREVIEW.toString(), path);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListItem delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }

    private void addHeaderParams(Request request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

