/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.SyncList;

public class SyncListReader
extends Reader<SyncList> {
    private String pathServiceSid;
    private Integer pageSize;

    public SyncListReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SyncListReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SyncList> read(TwilioRestClient client) {
        return new ResourceSet<SyncList>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncList> firstPage(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Lists";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SyncList> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncList read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("lists", response.getContent(), SyncList.class, client.getObjectMapper());
    }

    @Override
    public Page<SyncList> previousPage(Page<SyncList> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncList> nextPage(Page<SyncList> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncList> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

