/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.oauth.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.oauth.v1.Authorize;

public class AuthorizeFetcher
extends Fetcher<Authorize> {
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String scope;
    private String state;

    public AuthorizeFetcher setResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public AuthorizeFetcher setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public AuthorizeFetcher setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public AuthorizeFetcher setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public AuthorizeFetcher setState(String state) {
        this.state = state;
        return this;
    }

    @Override
    public Authorize fetch(TwilioRestClient client) {
        String path = "/v1/authorize";
        Request request = new Request(HttpMethod.GET, Domains.OAUTH.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Authorize fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Authorize.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.responseType != null) {
            request.addQueryParam("ResponseType", this.responseType);
        }
        if (this.clientId != null) {
            request.addQueryParam("ClientId", this.clientId);
        }
        if (this.redirectUri != null) {
            request.addQueryParam("RedirectUri", this.redirectUri);
        }
        if (this.scope != null) {
            request.addQueryParam("Scope", this.scope);
        }
        if (this.state != null) {
            request.addQueryParam("State", this.state);
        }
    }
}

