/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.Bundle;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class BundleReader
extends Reader<Bundle> {
    private Bundle.Status status;
    private String friendlyName;
    private String regulationSid;
    private String isoCountry;
    private String numberType;
    private Boolean hasValidUntilDate;
    private Bundle.SortBy sortBy;
    private Bundle.SortDirection sortDirection;
    private ZonedDateTime validUntilDate;
    private ZonedDateTime validUntilDateBefore;
    private ZonedDateTime validUntilDateAfter;
    private Integer pageSize;

    public BundleReader setStatus(Bundle.Status status) {
        this.status = status;
        return this;
    }

    public BundleReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public BundleReader setRegulationSid(String regulationSid) {
        this.regulationSid = regulationSid;
        return this;
    }

    public BundleReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public BundleReader setNumberType(String numberType) {
        this.numberType = numberType;
        return this;
    }

    public BundleReader setHasValidUntilDate(Boolean hasValidUntilDate) {
        this.hasValidUntilDate = hasValidUntilDate;
        return this;
    }

    public BundleReader setSortBy(Bundle.SortBy sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public BundleReader setSortDirection(Bundle.SortDirection sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    public BundleReader setValidUntilDate(ZonedDateTime validUntilDate) {
        this.validUntilDate = validUntilDate;
        return this;
    }

    public BundleReader setValidUntilDateBefore(ZonedDateTime validUntilDateBefore) {
        this.validUntilDateBefore = validUntilDateBefore;
        return this;
    }

    public BundleReader setValidUntilDateAfter(ZonedDateTime validUntilDateAfter) {
        this.validUntilDateAfter = validUntilDateAfter;
        return this;
    }

    public BundleReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Bundle> read(TwilioRestClient client) {
        return new ResourceSet<Bundle>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Bundle> firstPage(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Bundles";
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Bundle> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bundle read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), Bundle.class, client.getObjectMapper());
    }

    @Override
    public Page<Bundle> previousPage(Page<Bundle> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bundle> nextPage(Page<Bundle> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bundle> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.regulationSid != null) {
            request.addQueryParam("RegulationSid", this.regulationSid);
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.numberType != null) {
            request.addQueryParam("NumberType", this.numberType);
        }
        if (this.hasValidUntilDate != null) {
            request.addQueryParam("HasValidUntilDate", this.hasValidUntilDate.toString());
        }
        if (this.sortBy != null) {
            request.addQueryParam("SortBy", this.sortBy.toString());
        }
        if (this.sortDirection != null) {
            request.addQueryParam("SortDirection", this.sortDirection.toString());
        }
        if (this.validUntilDate != null) {
            request.addQueryParam("ValidUntilDate", this.validUntilDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        } else if (this.validUntilDateAfter != null || this.validUntilDateBefore != null) {
            request.addQueryDateTimeRange("ValidUntilDate", this.validUntilDateAfter, this.validUntilDateBefore);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

