/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.BundleCreator;
import com.twilio.rest.numbers.v2.regulatorycompliance.BundleDeleter;
import com.twilio.rest.numbers.v2.regulatorycompliance.BundleFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.BundleReader;
import com.twilio.rest.numbers.v2.regulatorycompliance.BundleUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Bundle
extends Resource {
    private static final long serialVersionUID = 198185819431201L;
    private final String sid;
    private final String accountSid;
    private final String regulationSid;
    private final String friendlyName;
    private final Status status;
    private final ZonedDateTime validUntil;
    private final String email;
    private final URI statusCallback;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static BundleCreator creator(String friendlyName, String email) {
        return new BundleCreator(friendlyName, email);
    }

    public static BundleDeleter deleter(String pathSid) {
        return new BundleDeleter(pathSid);
    }

    public static BundleFetcher fetcher(String pathSid) {
        return new BundleFetcher(pathSid);
    }

    public static BundleReader reader() {
        return new BundleReader();
    }

    public static BundleUpdater updater(String pathSid) {
        return new BundleUpdater(pathSid);
    }

    public static Bundle fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Bundle.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Bundle fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Bundle.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Bundle(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="regulation_sid") String regulationSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") Status status, @JsonProperty(value="valid_until") String validUntil, @JsonProperty(value="email") String email, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.regulationSid = regulationSid;
        this.friendlyName = friendlyName;
        this.status = status;
        this.validUntil = DateConverter.iso8601DateTimeFromString(validUntil);
        this.email = email;
        this.statusCallback = statusCallback;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRegulationSid() {
        return this.regulationSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle other = (Bundle)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.regulationSid, other.regulationSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.validUntil, other.validUntil) && Objects.equals(this.email, other.email) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.regulationSid, this.friendlyName, this.status, this.validUntil, this.email, this.statusCallback, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return "Bundle(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", regulationSid=" + this.getRegulationSid() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", validUntil=" + this.getValidUntil() + ", email=" + this.getEmail() + ", statusCallback=" + this.getStatusCallback() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PENDING_REVIEW("pending-review"),
        IN_REVIEW("in-review"),
        TWILIO_REJECTED("twilio-rejected"),
        TWILIO_APPROVED("twilio-approved"),
        PROVISIONALLY_APPROVED("provisionally-approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum SortDirection {
        ASC("ASC"),
        DESC("DESC");

        private final String value;

        private SortDirection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SortDirection forValue(String value) {
            return (SortDirection)Promoter.enumFromString((String)value, (Enum[])SortDirection.values());
        }
    }

    public static enum SortBy {
        VALID_UNTIL("valid-until"),
        DATE_UPDATED("date-updated");

        private final String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SortBy forValue(String value) {
            return (SortBy)Promoter.enumFromString((String)value, (Enum[])SortBy.values());
        }
    }

    public static enum EndUserType {
        INDIVIDUAL("individual"),
        BUSINESS("business");

        private final String value;

        private EndUserType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EndUserType forValue(String value) {
            return (EndUserType)Promoter.enumFromString((String)value, (Enum[])EndUserType.values());
        }
    }
}

