/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1.device;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.microvisor.v1.device.DeviceSecret;

public class DeviceSecretCreator
extends Creator<DeviceSecret> {
    private String pathDeviceSid;
    private String key;
    private String value;

    public DeviceSecretCreator(String pathDeviceSid, String key, String value) {
        this.pathDeviceSid = pathDeviceSid;
        this.key = key;
        this.value = value;
    }

    public DeviceSecretCreator setKey(String key) {
        this.key = key;
        return this;
    }

    public DeviceSecretCreator setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public DeviceSecret create(TwilioRestClient client) {
        String path = "/v1/Devices/{DeviceSid}/Secrets";
        path = path.replace("{DeviceSid}", this.pathDeviceSid.toString());
        path = path.replace("{Key}", this.key.toString());
        path = path.replace("{Value}", this.value.toString());
        Request request = new Request(HttpMethod.POST, Domains.MICROVISOR.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeviceSecret creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DeviceSecret.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.key != null) {
            request.addPostParam("Key", this.key);
        }
        if (this.value != null) {
            request.addPostParam("Value", this.value);
        }
    }
}

