/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.microvisor.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.microvisor.v1.AccountConfigCreator;
import com.twilio.rest.microvisor.v1.AccountConfigDeleter;
import com.twilio.rest.microvisor.v1.AccountConfigFetcher;
import com.twilio.rest.microvisor.v1.AccountConfigReader;
import com.twilio.rest.microvisor.v1.AccountConfigUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountConfig
extends Resource {
    private static final long serialVersionUID = 212393375904180L;
    private final String key;
    private final ZonedDateTime dateUpdated;
    private final String value;
    private final URI url;

    public static AccountConfigCreator creator(String key, String value) {
        return new AccountConfigCreator(key, value);
    }

    public static AccountConfigDeleter deleter(String pathKey) {
        return new AccountConfigDeleter(pathKey);
    }

    public static AccountConfigFetcher fetcher(String pathKey) {
        return new AccountConfigFetcher(pathKey);
    }

    public static AccountConfigReader reader() {
        return new AccountConfigReader();
    }

    public static AccountConfigUpdater updater(String pathKey, String value) {
        return new AccountConfigUpdater(pathKey, value);
    }

    public static AccountConfig fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccountConfig.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AccountConfig fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AccountConfig.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AccountConfig(@JsonProperty(value="key") String key, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="value") String value, @JsonProperty(value="url") URI url) {
        this.key = key;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.value = value;
        this.url = url;
    }

    public final String getKey() {
        return this.key;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getValue() {
        return this.value;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountConfig other = (AccountConfig)o;
        return Objects.equals(this.key, other.key) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.value, other.value) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.dateUpdated, this.value, this.url);
    }

    public String toString() {
        return "AccountConfig(key=" + this.getKey() + ", dateUpdated=" + this.getDateUpdated() + ", value=" + this.getValue() + ", url=" + this.getUrl() + ")";
    }
}

