/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.service.ChannelSenderFetcher;
import com.twilio.rest.messaging.v1.service.ChannelSenderReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChannelSender
extends Resource {
    private static final long serialVersionUID = 32697428616380L;
    private final String accountSid;
    private final String messagingServiceSid;
    private final String sid;
    private final String sender;
    private final String senderType;
    private final String countryCode;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static ChannelSenderFetcher fetcher(String pathMessagingServiceSid, String pathSid) {
        return new ChannelSenderFetcher(pathMessagingServiceSid, pathSid);
    }

    public static ChannelSenderReader reader(String pathMessagingServiceSid) {
        return new ChannelSenderReader(pathMessagingServiceSid);
    }

    public static ChannelSender fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ChannelSender.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ChannelSender fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ChannelSender.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ChannelSender(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="sender") String sender, @JsonProperty(value="sender_type") String senderType, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.messagingServiceSid = messagingServiceSid;
        this.sid = sid;
        this.sender = sender;
        this.senderType = senderType;
        this.countryCode = countryCode;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSender() {
        return this.sender;
    }

    public final String getSenderType() {
        return this.senderType;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelSender other = (ChannelSender)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.sender, other.sender) && Objects.equals(this.senderType, other.senderType) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.messagingServiceSid, this.sid, this.sender, this.senderType, this.countryCode, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "ChannelSender(accountSid=" + this.getAccountSid() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", sid=" + this.getSid() + ", sender=" + this.getSender() + ", senderType=" + this.getSenderType() + ", countryCode=" + this.getCountryCode() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

