/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.brandregistration;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.brandregistration.BrandVetting;

public class BrandVettingFetcher
extends Fetcher<BrandVetting> {
    private String pathBrandSid;
    private String pathBrandVettingSid;

    public BrandVettingFetcher(String pathBrandSid, String pathBrandVettingSid) {
        this.pathBrandSid = pathBrandSid;
        this.pathBrandVettingSid = pathBrandVettingSid;
    }

    @Override
    public BrandVetting fetch(TwilioRestClient client) {
        String path = "/v1/a2p/BrandRegistrations/{BrandSid}/Vettings/{BrandVettingSid}";
        path = path.replace("{BrandSid}", this.pathBrandSid.toString());
        path = path.replace("{BrandVettingSid}", this.pathBrandVettingSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandVetting fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BrandVetting.fromJson(response.getStream(), client.getObjectMapper());
    }
}

