/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.brandregistration;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.brandregistration.BrandRegistrationOtp;

public class BrandRegistrationOtpCreator
extends Creator<BrandRegistrationOtp> {
    private String pathBrandRegistrationSid;

    public BrandRegistrationOtpCreator(String pathBrandRegistrationSid) {
        this.pathBrandRegistrationSid = pathBrandRegistrationSid;
    }

    @Override
    public BrandRegistrationOtp create(TwilioRestClient client) {
        String path = "/v1/a2p/BrandRegistrations/{BrandRegistrationSid}/SmsOtp";
        path = path.replace("{BrandRegistrationSid}", this.pathBrandRegistrationSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandRegistrationOtp creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BrandRegistrationOtp.fromJson(response.getStream(), client.getObjectMapper());
    }
}

