/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.TollfreeVerificationCreator;
import com.twilio.rest.messaging.v1.TollfreeVerificationDeleter;
import com.twilio.rest.messaging.v1.TollfreeVerificationFetcher;
import com.twilio.rest.messaging.v1.TollfreeVerificationReader;
import com.twilio.rest.messaging.v1.TollfreeVerificationUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TollfreeVerification
extends Resource {
    private static final long serialVersionUID = 271545419096190L;
    private final String sid;
    private final String accountSid;
    private final String customerProfileSid;
    private final String trustProductSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String regulatedItemSid;
    private final String businessName;
    private final String businessStreetAddress;
    private final String businessStreetAddress2;
    private final String businessCity;
    private final String businessStateProvinceRegion;
    private final String businessPostalCode;
    private final String businessCountry;
    private final String businessWebsite;
    private final String businessContactFirstName;
    private final String businessContactLastName;
    private final String businessContactEmail;
    private final PhoneNumber businessContactPhone;
    private final String notificationEmail;
    private final List<String> useCaseCategories;
    private final String useCaseSummary;
    private final String productionMessageSample;
    private final List<String> optInImageUrls;
    private final OptInType optInType;
    private final String messageVolume;
    private final String additionalInformation;
    private final String tollfreePhoneNumberSid;
    private final Status status;
    private final URI url;
    private final String rejectionReason;
    private final Integer errorCode;
    private final ZonedDateTime editExpiration;
    private final Boolean editAllowed;
    private final List<Map<String, Object>> rejectionReasons;
    private final Map<String, Object> resourceLinks;
    private final String externalReferenceId;

    public static TollfreeVerificationCreator creator(String businessName, String businessWebsite, String notificationEmail, List<String> useCaseCategories, String useCaseSummary, String productionMessageSample, List<String> optInImageUrls, OptInType optInType, String messageVolume, String tollfreePhoneNumberSid) {
        return new TollfreeVerificationCreator(businessName, businessWebsite, notificationEmail, useCaseCategories, useCaseSummary, productionMessageSample, optInImageUrls, optInType, messageVolume, tollfreePhoneNumberSid);
    }

    public static TollfreeVerificationDeleter deleter(String pathSid) {
        return new TollfreeVerificationDeleter(pathSid);
    }

    public static TollfreeVerificationFetcher fetcher(String pathSid) {
        return new TollfreeVerificationFetcher(pathSid);
    }

    public static TollfreeVerificationReader reader() {
        return new TollfreeVerificationReader();
    }

    public static TollfreeVerificationUpdater updater(String pathSid) {
        return new TollfreeVerificationUpdater(pathSid);
    }

    public static TollfreeVerification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TollfreeVerification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TollfreeVerification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TollfreeVerification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TollfreeVerification(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="customer_profile_sid") String customerProfileSid, @JsonProperty(value="trust_product_sid") String trustProductSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="regulated_item_sid") String regulatedItemSid, @JsonProperty(value="business_name") String businessName, @JsonProperty(value="business_street_address") String businessStreetAddress, @JsonProperty(value="business_street_address2") String businessStreetAddress2, @JsonProperty(value="business_city") String businessCity, @JsonProperty(value="business_state_province_region") String businessStateProvinceRegion, @JsonProperty(value="business_postal_code") String businessPostalCode, @JsonProperty(value="business_country") String businessCountry, @JsonProperty(value="business_website") String businessWebsite, @JsonProperty(value="business_contact_first_name") String businessContactFirstName, @JsonProperty(value="business_contact_last_name") String businessContactLastName, @JsonProperty(value="business_contact_email") String businessContactEmail, @JsonProperty(value="business_contact_phone") PhoneNumber businessContactPhone, @JsonProperty(value="notification_email") String notificationEmail, @JsonProperty(value="use_case_categories") List<String> useCaseCategories, @JsonProperty(value="use_case_summary") String useCaseSummary, @JsonProperty(value="production_message_sample") String productionMessageSample, @JsonProperty(value="opt_in_image_urls") List<String> optInImageUrls, @JsonProperty(value="opt_in_type") OptInType optInType, @JsonProperty(value="message_volume") String messageVolume, @JsonProperty(value="additional_information") String additionalInformation, @JsonProperty(value="tollfree_phone_number_sid") String tollfreePhoneNumberSid, @JsonProperty(value="status") Status status, @JsonProperty(value="url") URI url, @JsonProperty(value="rejection_reason") String rejectionReason, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="edit_expiration") String editExpiration, @JsonProperty(value="edit_allowed") Boolean editAllowed, @JsonProperty(value="rejection_reasons") List<Map<String, Object>> rejectionReasons, @JsonProperty(value="resource_links") Map<String, Object> resourceLinks, @JsonProperty(value="external_reference_id") String externalReferenceId) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.customerProfileSid = customerProfileSid;
        this.trustProductSid = trustProductSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.regulatedItemSid = regulatedItemSid;
        this.businessName = businessName;
        this.businessStreetAddress = businessStreetAddress;
        this.businessStreetAddress2 = businessStreetAddress2;
        this.businessCity = businessCity;
        this.businessStateProvinceRegion = businessStateProvinceRegion;
        this.businessPostalCode = businessPostalCode;
        this.businessCountry = businessCountry;
        this.businessWebsite = businessWebsite;
        this.businessContactFirstName = businessContactFirstName;
        this.businessContactLastName = businessContactLastName;
        this.businessContactEmail = businessContactEmail;
        this.businessContactPhone = businessContactPhone;
        this.notificationEmail = notificationEmail;
        this.useCaseCategories = useCaseCategories;
        this.useCaseSummary = useCaseSummary;
        this.productionMessageSample = productionMessageSample;
        this.optInImageUrls = optInImageUrls;
        this.optInType = optInType;
        this.messageVolume = messageVolume;
        this.additionalInformation = additionalInformation;
        this.tollfreePhoneNumberSid = tollfreePhoneNumberSid;
        this.status = status;
        this.url = url;
        this.rejectionReason = rejectionReason;
        this.errorCode = errorCode;
        this.editExpiration = DateConverter.iso8601DateTimeFromString(editExpiration);
        this.editAllowed = editAllowed;
        this.rejectionReasons = rejectionReasons;
        this.resourceLinks = resourceLinks;
        this.externalReferenceId = externalReferenceId;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCustomerProfileSid() {
        return this.customerProfileSid;
    }

    public final String getTrustProductSid() {
        return this.trustProductSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getRegulatedItemSid() {
        return this.regulatedItemSid;
    }

    public final String getBusinessName() {
        return this.businessName;
    }

    public final String getBusinessStreetAddress() {
        return this.businessStreetAddress;
    }

    public final String getBusinessStreetAddress2() {
        return this.businessStreetAddress2;
    }

    public final String getBusinessCity() {
        return this.businessCity;
    }

    public final String getBusinessStateProvinceRegion() {
        return this.businessStateProvinceRegion;
    }

    public final String getBusinessPostalCode() {
        return this.businessPostalCode;
    }

    public final String getBusinessCountry() {
        return this.businessCountry;
    }

    public final String getBusinessWebsite() {
        return this.businessWebsite;
    }

    public final String getBusinessContactFirstName() {
        return this.businessContactFirstName;
    }

    public final String getBusinessContactLastName() {
        return this.businessContactLastName;
    }

    public final String getBusinessContactEmail() {
        return this.businessContactEmail;
    }

    public final PhoneNumber getBusinessContactPhone() {
        return this.businessContactPhone;
    }

    public final String getNotificationEmail() {
        return this.notificationEmail;
    }

    public final List<String> getUseCaseCategories() {
        return this.useCaseCategories;
    }

    public final String getUseCaseSummary() {
        return this.useCaseSummary;
    }

    public final String getProductionMessageSample() {
        return this.productionMessageSample;
    }

    public final List<String> getOptInImageUrls() {
        return this.optInImageUrls;
    }

    public final OptInType getOptInType() {
        return this.optInType;
    }

    public final String getMessageVolume() {
        return this.messageVolume;
    }

    public final String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public final String getTollfreePhoneNumberSid() {
        return this.tollfreePhoneNumberSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getRejectionReason() {
        return this.rejectionReason;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final ZonedDateTime getEditExpiration() {
        return this.editExpiration;
    }

    public final Boolean getEditAllowed() {
        return this.editAllowed;
    }

    public final List<Map<String, Object>> getRejectionReasons() {
        return this.rejectionReasons;
    }

    public final Map<String, Object> getResourceLinks() {
        return this.resourceLinks;
    }

    public final String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TollfreeVerification other = (TollfreeVerification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.customerProfileSid, other.customerProfileSid) && Objects.equals(this.trustProductSid, other.trustProductSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.regulatedItemSid, other.regulatedItemSid) && Objects.equals(this.businessName, other.businessName) && Objects.equals(this.businessStreetAddress, other.businessStreetAddress) && Objects.equals(this.businessStreetAddress2, other.businessStreetAddress2) && Objects.equals(this.businessCity, other.businessCity) && Objects.equals(this.businessStateProvinceRegion, other.businessStateProvinceRegion) && Objects.equals(this.businessPostalCode, other.businessPostalCode) && Objects.equals(this.businessCountry, other.businessCountry) && Objects.equals(this.businessWebsite, other.businessWebsite) && Objects.equals(this.businessContactFirstName, other.businessContactFirstName) && Objects.equals(this.businessContactLastName, other.businessContactLastName) && Objects.equals(this.businessContactEmail, other.businessContactEmail) && Objects.equals(this.businessContactPhone, other.businessContactPhone) && Objects.equals(this.notificationEmail, other.notificationEmail) && Objects.equals(this.useCaseCategories, other.useCaseCategories) && Objects.equals(this.useCaseSummary, other.useCaseSummary) && Objects.equals(this.productionMessageSample, other.productionMessageSample) && Objects.equals(this.optInImageUrls, other.optInImageUrls) && Objects.equals((Object)this.optInType, (Object)other.optInType) && Objects.equals(this.messageVolume, other.messageVolume) && Objects.equals(this.additionalInformation, other.additionalInformation) && Objects.equals(this.tollfreePhoneNumberSid, other.tollfreePhoneNumberSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.url, other.url) && Objects.equals(this.rejectionReason, other.rejectionReason) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.editExpiration, other.editExpiration) && Objects.equals(this.editAllowed, other.editAllowed) && Objects.equals(this.rejectionReasons, other.rejectionReasons) && Objects.equals(this.resourceLinks, other.resourceLinks) && Objects.equals(this.externalReferenceId, other.externalReferenceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.customerProfileSid, this.trustProductSid, this.dateCreated, this.dateUpdated, this.regulatedItemSid, this.businessName, this.businessStreetAddress, this.businessStreetAddress2, this.businessCity, this.businessStateProvinceRegion, this.businessPostalCode, this.businessCountry, this.businessWebsite, this.businessContactFirstName, this.businessContactLastName, this.businessContactEmail, this.businessContactPhone, this.notificationEmail, this.useCaseCategories, this.useCaseSummary, this.productionMessageSample, this.optInImageUrls, this.optInType, this.messageVolume, this.additionalInformation, this.tollfreePhoneNumberSid, this.status, this.url, this.rejectionReason, this.errorCode, this.editExpiration, this.editAllowed, this.rejectionReasons, this.resourceLinks, this.externalReferenceId});
    }

    public String toString() {
        return "TollfreeVerification(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", customerProfileSid=" + this.getCustomerProfileSid() + ", trustProductSid=" + this.getTrustProductSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", regulatedItemSid=" + this.getRegulatedItemSid() + ", businessName=" + this.getBusinessName() + ", businessStreetAddress=" + this.getBusinessStreetAddress() + ", businessStreetAddress2=" + this.getBusinessStreetAddress2() + ", businessCity=" + this.getBusinessCity() + ", businessStateProvinceRegion=" + this.getBusinessStateProvinceRegion() + ", businessPostalCode=" + this.getBusinessPostalCode() + ", businessCountry=" + this.getBusinessCountry() + ", businessWebsite=" + this.getBusinessWebsite() + ", businessContactFirstName=" + this.getBusinessContactFirstName() + ", businessContactLastName=" + this.getBusinessContactLastName() + ", businessContactEmail=" + this.getBusinessContactEmail() + ", businessContactPhone=" + this.getBusinessContactPhone() + ", notificationEmail=" + this.getNotificationEmail() + ", useCaseCategories=" + this.getUseCaseCategories() + ", useCaseSummary=" + this.getUseCaseSummary() + ", productionMessageSample=" + this.getProductionMessageSample() + ", optInImageUrls=" + this.getOptInImageUrls() + ", optInType=" + (Object)((Object)this.getOptInType()) + ", messageVolume=" + this.getMessageVolume() + ", additionalInformation=" + this.getAdditionalInformation() + ", tollfreePhoneNumberSid=" + this.getTollfreePhoneNumberSid() + ", status=" + (Object)((Object)this.getStatus()) + ", url=" + this.getUrl() + ", rejectionReason=" + this.getRejectionReason() + ", errorCode=" + this.getErrorCode() + ", editExpiration=" + this.getEditExpiration() + ", editAllowed=" + this.getEditAllowed() + ", rejectionReasons=" + this.getRejectionReasons() + ", resourceLinks=" + this.getResourceLinks() + ", externalReferenceId=" + this.getExternalReferenceId() + ")";
    }

    public static enum OptInType {
        VERBAL("VERBAL"),
        WEB_FORM("WEB_FORM"),
        PAPER_FORM("PAPER_FORM"),
        VIA_TEXT("VIA_TEXT"),
        MOBILE_QR_CODE("MOBILE_QR_CODE");

        private final String value;

        private OptInType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static OptInType forValue(String value) {
            return (OptInType)Promoter.enumFromString((String)value, (Enum[])OptInType.values());
        }
    }

    public static enum Status {
        PENDING_REVIEW("PENDING_REVIEW"),
        IN_REVIEW("IN_REVIEW"),
        TWILIO_APPROVED("TWILIO_APPROVED"),
        TWILIO_REJECTED("TWILIO_REJECTED");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

