/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.messaging.v1.ServiceCreator;
import com.twilio.rest.messaging.v1.ServiceDeleter;
import com.twilio.rest.messaging.v1.ServiceFetcher;
import com.twilio.rest.messaging.v1.ServiceReader;
import com.twilio.rest.messaging.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 59018314319448L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI inboundRequestUrl;
    private final HttpMethod inboundMethod;
    private final URI fallbackUrl;
    private final HttpMethod fallbackMethod;
    private final URI statusCallback;
    private final Boolean stickySender;
    private final Boolean mmsConverter;
    private final Boolean smartEncoding;
    private final ScanMessageContent scanMessageContent;
    private final Boolean fallbackToLongCode;
    private final Boolean areaCodeGeomatch;
    private final Boolean synchronousValidation;
    private final Integer validityPeriod;
    private final URI url;
    private final Map<String, String> links;
    private final String usecase;
    private final Boolean usAppToPersonRegistered;
    private final Boolean useInboundWebhookOnNumber;

    public static ServiceCreator creator(String friendlyName) {
        return new ServiceCreator(friendlyName);
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="inbound_request_url") URI inboundRequestUrl, @JsonProperty(value="inbound_method") HttpMethod inboundMethod, @JsonProperty(value="fallback_url") URI fallbackUrl, @JsonProperty(value="fallback_method") HttpMethod fallbackMethod, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="sticky_sender") Boolean stickySender, @JsonProperty(value="mms_converter") Boolean mmsConverter, @JsonProperty(value="smart_encoding") Boolean smartEncoding, @JsonProperty(value="scan_message_content") ScanMessageContent scanMessageContent, @JsonProperty(value="fallback_to_long_code") Boolean fallbackToLongCode, @JsonProperty(value="area_code_geomatch") Boolean areaCodeGeomatch, @JsonProperty(value="synchronous_validation") Boolean synchronousValidation, @JsonProperty(value="validity_period") Integer validityPeriod, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="usecase") String usecase, @JsonProperty(value="us_app_to_person_registered") Boolean usAppToPersonRegistered, @JsonProperty(value="use_inbound_webhook_on_number") Boolean useInboundWebhookOnNumber) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.inboundRequestUrl = inboundRequestUrl;
        this.inboundMethod = inboundMethod;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.stickySender = stickySender;
        this.mmsConverter = mmsConverter;
        this.smartEncoding = smartEncoding;
        this.scanMessageContent = scanMessageContent;
        this.fallbackToLongCode = fallbackToLongCode;
        this.areaCodeGeomatch = areaCodeGeomatch;
        this.synchronousValidation = synchronousValidation;
        this.validityPeriod = validityPeriod;
        this.url = url;
        this.links = links;
        this.usecase = usecase;
        this.usAppToPersonRegistered = usAppToPersonRegistered;
        this.useInboundWebhookOnNumber = useInboundWebhookOnNumber;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getInboundRequestUrl() {
        return this.inboundRequestUrl;
    }

    public final HttpMethod getInboundMethod() {
        return this.inboundMethod;
    }

    public final URI getFallbackUrl() {
        return this.fallbackUrl;
    }

    public final HttpMethod getFallbackMethod() {
        return this.fallbackMethod;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final Boolean getStickySender() {
        return this.stickySender;
    }

    public final Boolean getMmsConverter() {
        return this.mmsConverter;
    }

    public final Boolean getSmartEncoding() {
        return this.smartEncoding;
    }

    public final ScanMessageContent getScanMessageContent() {
        return this.scanMessageContent;
    }

    public final Boolean getFallbackToLongCode() {
        return this.fallbackToLongCode;
    }

    public final Boolean getAreaCodeGeomatch() {
        return this.areaCodeGeomatch;
    }

    public final Boolean getSynchronousValidation() {
        return this.synchronousValidation;
    }

    public final Integer getValidityPeriod() {
        return this.validityPeriod;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getUsecase() {
        return this.usecase;
    }

    public final Boolean getUsAppToPersonRegistered() {
        return this.usAppToPersonRegistered;
    }

    public final Boolean getUseInboundWebhookOnNumber() {
        return this.useInboundWebhookOnNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.inboundRequestUrl, other.inboundRequestUrl) && Objects.equals((Object)this.inboundMethod, (Object)other.inboundMethod) && Objects.equals(this.fallbackUrl, other.fallbackUrl) && Objects.equals((Object)this.fallbackMethod, (Object)other.fallbackMethod) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals(this.stickySender, other.stickySender) && Objects.equals(this.mmsConverter, other.mmsConverter) && Objects.equals(this.smartEncoding, other.smartEncoding) && Objects.equals((Object)this.scanMessageContent, (Object)other.scanMessageContent) && Objects.equals(this.fallbackToLongCode, other.fallbackToLongCode) && Objects.equals(this.areaCodeGeomatch, other.areaCodeGeomatch) && Objects.equals(this.synchronousValidation, other.synchronousValidation) && Objects.equals(this.validityPeriod, other.validityPeriod) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.usecase, other.usecase) && Objects.equals(this.usAppToPersonRegistered, other.usAppToPersonRegistered) && Objects.equals(this.useInboundWebhookOnNumber, other.useInboundWebhookOnNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.inboundRequestUrl, this.inboundMethod, this.fallbackUrl, this.fallbackMethod, this.statusCallback, this.stickySender, this.mmsConverter, this.smartEncoding, this.scanMessageContent, this.fallbackToLongCode, this.areaCodeGeomatch, this.synchronousValidation, this.validityPeriod, this.url, this.links, this.usecase, this.usAppToPersonRegistered, this.useInboundWebhookOnNumber});
    }

    public String toString() {
        return "Service(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", inboundRequestUrl=" + this.getInboundRequestUrl() + ", inboundMethod=" + (Object)((Object)this.getInboundMethod()) + ", fallbackUrl=" + this.getFallbackUrl() + ", fallbackMethod=" + (Object)((Object)this.getFallbackMethod()) + ", statusCallback=" + this.getStatusCallback() + ", stickySender=" + this.getStickySender() + ", mmsConverter=" + this.getMmsConverter() + ", smartEncoding=" + this.getSmartEncoding() + ", scanMessageContent=" + (Object)((Object)this.getScanMessageContent()) + ", fallbackToLongCode=" + this.getFallbackToLongCode() + ", areaCodeGeomatch=" + this.getAreaCodeGeomatch() + ", synchronousValidation=" + this.getSynchronousValidation() + ", validityPeriod=" + this.getValidityPeriod() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", usecase=" + this.getUsecase() + ", usAppToPersonRegistered=" + this.getUsAppToPersonRegistered() + ", useInboundWebhookOnNumber=" + this.getUseInboundWebhookOnNumber() + ")";
    }

    public static enum ScanMessageContent {
        INHERIT("inherit"),
        ENABLE("enable"),
        DISABLE("disable");

        private final String value;

        private ScanMessageContent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ScanMessageContent forValue(String value) {
            return (ScanMessageContent)Promoter.enumFromString((String)value, (Enum[])ScanMessageContent.values());
        }
    }
}

