/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.ExternalCampaign;

public class ExternalCampaignCreator
extends Creator<ExternalCampaign> {
    private String campaignId;
    private String messagingServiceSid;

    public ExternalCampaignCreator(String campaignId, String messagingServiceSid) {
        this.campaignId = campaignId;
        this.messagingServiceSid = messagingServiceSid;
    }

    public ExternalCampaignCreator setCampaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public ExternalCampaignCreator setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    @Override
    public ExternalCampaign create(TwilioRestClient client) {
        String path = "/v1/Services/PreregisteredUsa2p";
        path = path.replace("{CampaignId}", this.campaignId.toString());
        path = path.replace("{MessagingServiceSid}", this.messagingServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExternalCampaign creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ExternalCampaign.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.campaignId != null) {
            request.addPostParam("CampaignId", this.campaignId);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
    }
}

