/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.DomainConfig;
import java.net.URI;

public class DomainConfigUpdater
extends Updater<DomainConfig> {
    private String pathDomainSid;
    private URI fallbackUrl;
    private URI callbackUrl;
    private Boolean continueOnFailure;
    private Boolean disableHttps;

    public DomainConfigUpdater(String pathDomainSid) {
        this.pathDomainSid = pathDomainSid;
    }

    public DomainConfigUpdater setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public DomainConfigUpdater setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public DomainConfigUpdater setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public DomainConfigUpdater setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public DomainConfigUpdater setContinueOnFailure(Boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
        return this;
    }

    public DomainConfigUpdater setDisableHttps(Boolean disableHttps) {
        this.disableHttps = disableHttps;
        return this;
    }

    @Override
    public DomainConfig update(TwilioRestClient client) {
        String path = "/v1/LinkShortening/Domains/{DomainSid}/Config";
        path = path.replace("{DomainSid}", this.pathDomainSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DomainConfig update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return DomainConfig.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.continueOnFailure != null) {
            request.addPostParam("ContinueOnFailure", this.continueOnFailure.toString());
        }
        if (this.disableHttps != null) {
            request.addPostParam("DisableHttps", this.disableHttps.toString());
        }
    }
}

