/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.DomainCertsDeleter;
import com.twilio.rest.messaging.v1.DomainCertsFetcher;
import com.twilio.rest.messaging.v1.DomainCertsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DomainCerts
extends Resource {
    private static final long serialVersionUID = 200335100401859L;
    private final String domainSid;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateExpires;
    private final ZonedDateTime dateCreated;
    private final URI domainName;
    private final String certificateSid;
    private final URI url;
    private final Map<String, Object> certInValidation;

    public static DomainCertsDeleter deleter(String pathDomainSid) {
        return new DomainCertsDeleter(pathDomainSid);
    }

    public static DomainCertsFetcher fetcher(String pathDomainSid) {
        return new DomainCertsFetcher(pathDomainSid);
    }

    public static DomainCertsUpdater updater(String pathDomainSid, String tlsCert) {
        return new DomainCertsUpdater(pathDomainSid, tlsCert);
    }

    public static DomainCerts fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DomainCerts.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DomainCerts fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, DomainCerts.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DomainCerts(@JsonProperty(value="domain_sid") String domainSid, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_expires") String dateExpires, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="domain_name") URI domainName, @JsonProperty(value="certificate_sid") String certificateSid, @JsonProperty(value="url") URI url, @JsonProperty(value="cert_in_validation") Map<String, Object> certInValidation) {
        this.domainSid = domainSid;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateExpires = DateConverter.iso8601DateTimeFromString(dateExpires);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.domainName = domainName;
        this.certificateSid = certificateSid;
        this.url = url;
        this.certInValidation = certInValidation;
    }

    public final String getDomainSid() {
        return this.domainSid;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateExpires() {
        return this.dateExpires;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getDomainName() {
        return this.domainName;
    }

    public final String getCertificateSid() {
        return this.certificateSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getCertInValidation() {
        return this.certInValidation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainCerts other = (DomainCerts)o;
        return Objects.equals(this.domainSid, other.domainSid) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateExpires, other.dateExpires) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.certificateSid, other.certificateSid) && Objects.equals(this.url, other.url) && Objects.equals(this.certInValidation, other.certInValidation);
    }

    public int hashCode() {
        return Objects.hash(this.domainSid, this.dateUpdated, this.dateExpires, this.dateCreated, this.domainName, this.certificateSid, this.url, this.certInValidation);
    }

    public String toString() {
        return "DomainCerts(domainSid=" + this.getDomainSid() + ", dateUpdated=" + this.getDateUpdated() + ", dateExpires=" + this.getDateExpires() + ", dateCreated=" + this.getDateCreated() + ", domainName=" + this.getDomainName() + ", certificateSid=" + this.getCertificateSid() + ", url=" + this.getUrl() + ", certInValidation=" + this.getCertInValidation() + ")";
    }
}

