/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.BrandRegistration;

public class BrandRegistrationCreator
extends Creator<BrandRegistration> {
    private String customerProfileBundleSid;
    private String a2PProfileBundleSid;
    private String brandType;
    private Boolean mock;
    private Boolean skipAutomaticSecVet;

    public BrandRegistrationCreator(String customerProfileBundleSid, String a2PProfileBundleSid) {
        this.customerProfileBundleSid = customerProfileBundleSid;
        this.a2PProfileBundleSid = a2PProfileBundleSid;
    }

    public BrandRegistrationCreator setCustomerProfileBundleSid(String customerProfileBundleSid) {
        this.customerProfileBundleSid = customerProfileBundleSid;
        return this;
    }

    public BrandRegistrationCreator setA2PProfileBundleSid(String a2PProfileBundleSid) {
        this.a2PProfileBundleSid = a2PProfileBundleSid;
        return this;
    }

    public BrandRegistrationCreator setBrandType(String brandType) {
        this.brandType = brandType;
        return this;
    }

    public BrandRegistrationCreator setMock(Boolean mock) {
        this.mock = mock;
        return this;
    }

    public BrandRegistrationCreator setSkipAutomaticSecVet(Boolean skipAutomaticSecVet) {
        this.skipAutomaticSecVet = skipAutomaticSecVet;
        return this;
    }

    @Override
    public BrandRegistration create(TwilioRestClient client) {
        String path = "/v1/a2p/BrandRegistrations";
        path = path.replace("{CustomerProfileBundleSid}", this.customerProfileBundleSid.toString());
        path = path.replace("{A2PProfileBundleSid}", this.a2PProfileBundleSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandRegistration creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return BrandRegistration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.customerProfileBundleSid != null) {
            request.addPostParam("CustomerProfileBundleSid", this.customerProfileBundleSid);
        }
        if (this.a2PProfileBundleSid != null) {
            request.addPostParam("A2PProfileBundleSid", this.a2PProfileBundleSid);
        }
        if (this.brandType != null) {
            request.addPostParam("BrandType", this.brandType);
        }
        if (this.mock != null) {
            request.addPostParam("Mock", this.mock.toString());
        }
        if (this.skipAutomaticSecVet != null) {
            request.addPostParam("SkipAutomaticSecVet", this.skipAutomaticSecVet.toString());
        }
    }
}

