/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.user;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.user.UserBinding;
import java.util.List;

public class UserBindingReader
extends Reader<UserBinding> {
    private String pathServiceSid;
    private String pathUserSid;
    private List<UserBinding.BindingType> bindingType;
    private Integer pageSize;

    public UserBindingReader(String pathServiceSid, String pathUserSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathUserSid = pathUserSid;
    }

    public UserBindingReader setBindingType(List<UserBinding.BindingType> bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    public UserBindingReader setBindingType(UserBinding.BindingType bindingType) {
        return this.setBindingType(Promoter.listOfOne(bindingType));
    }

    public UserBindingReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<UserBinding> read(TwilioRestClient client) {
        return new ResourceSet<UserBinding>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UserBinding> firstPage(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users/{UserSid}/Bindings";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.IPMESSAGING.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<UserBinding> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserBinding read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("bindings", response.getContent(), UserBinding.class, client.getObjectMapper());
    }

    @Override
    public Page<UserBinding> previousPage(Page<UserBinding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.IPMESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserBinding> nextPage(Page<UserBinding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.IPMESSAGING.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UserBinding> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.bindingType != null) {
            for (UserBinding.BindingType prop : this.bindingType) {
                request.addQueryParam("BindingType", prop.toString());
            }
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

