/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.Role;
import java.util.List;

public class RoleCreator
extends Creator<Role> {
    private String pathServiceSid;
    private String friendlyName;
    private Role.RoleType type;
    private List<String> permission;

    public RoleCreator(String pathServiceSid, String friendlyName, Role.RoleType type, List<String> permission) {
        this.pathServiceSid = pathServiceSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.permission = permission;
    }

    public RoleCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public RoleCreator setType(Role.RoleType type) {
        this.type = type;
        return this;
    }

    public RoleCreator setPermission(List<String> permission) {
        this.permission = permission;
        return this;
    }

    public RoleCreator setPermission(String permission) {
        return this.setPermission(Promoter.listOfOne(permission));
    }

    @Override
    public Role create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Roles";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{Type}", this.type.toString());
        path = path.replace("{Permission}", this.permission.toString());
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop);
            }
        }
    }
}

