/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.Role;
import java.util.List;

public class RoleUpdater
extends Updater<Role> {
    private String pathServiceSid;
    private String pathSid;
    private List<String> permission;

    public RoleUpdater(String pathServiceSid, String pathSid, List<String> permission) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
        this.permission = permission;
    }

    public RoleUpdater setPermission(List<String> permission) {
        this.permission = permission;
        return this;
    }

    public RoleUpdater setPermission(String permission) {
        return this.setPermission(Promoter.listOfOne(permission));
    }

    @Override
    public Role update(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Roles/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        path = path.replace("{Permission}", this.permission.toString());
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop);
            }
        }
    }
}

