/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2.transcript;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.intelligence.v2.transcript.OperatorResult;

public class OperatorResultFetcher
extends Fetcher<OperatorResult> {
    private String pathTranscriptSid;
    private String pathOperatorSid;
    private Boolean redacted;

    public OperatorResultFetcher(String pathTranscriptSid, String pathOperatorSid) {
        this.pathTranscriptSid = pathTranscriptSid;
        this.pathOperatorSid = pathOperatorSid;
    }

    public OperatorResultFetcher setRedacted(Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    @Override
    public OperatorResult fetch(TwilioRestClient client) {
        String path = "/v2/Transcripts/{TranscriptSid}/OperatorResults/{OperatorSid}";
        path = path.replace("{TranscriptSid}", this.pathTranscriptSid.toString());
        path = path.replace("{OperatorSid}", this.pathOperatorSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INTELLIGENCE.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OperatorResult fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return OperatorResult.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.redacted != null) {
            request.addQueryParam("Redacted", this.redacted.toString());
        }
    }
}

