/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.conference;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.conference.ConferenceParticipant;

public class ConferenceParticipantReader
extends Reader<ConferenceParticipant> {
    private String pathConferenceSid;
    private String participantSid;
    private String label;
    private String events;
    private Integer pageSize;

    public ConferenceParticipantReader(String pathConferenceSid) {
        this.pathConferenceSid = pathConferenceSid;
    }

    public ConferenceParticipantReader setParticipantSid(String participantSid) {
        this.participantSid = participantSid;
        return this;
    }

    public ConferenceParticipantReader setLabel(String label) {
        this.label = label;
        return this;
    }

    public ConferenceParticipantReader setEvents(String events) {
        this.events = events;
        return this;
    }

    public ConferenceParticipantReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<ConferenceParticipant> read(TwilioRestClient client) {
        return new ResourceSet<ConferenceParticipant>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ConferenceParticipant> firstPage(TwilioRestClient client) {
        String path = "/v1/Conferences/{ConferenceSid}/Participants";
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<ConferenceParticipant> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConferenceParticipant read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("participants", response.getContent(), ConferenceParticipant.class, client.getObjectMapper());
    }

    @Override
    public Page<ConferenceParticipant> previousPage(Page<ConferenceParticipant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConferenceParticipant> nextPage(Page<ConferenceParticipant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConferenceParticipant> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.participantSid != null) {
            request.addQueryParam("ParticipantSid", this.participantSid);
        }
        if (this.label != null) {
            request.addQueryParam("Label", this.label);
        }
        if (this.events != null) {
            request.addQueryParam("Events", this.events);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

