/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.call.Metric;

public class MetricReader
extends Reader<Metric> {
    private String pathCallSid;
    private Metric.TwilioEdge edge;
    private Metric.StreamDirection direction;
    private Integer pageSize;

    public MetricReader(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public MetricReader setEdge(Metric.TwilioEdge edge) {
        this.edge = edge;
        return this;
    }

    public MetricReader setDirection(Metric.StreamDirection direction) {
        this.direction = direction;
        return this;
    }

    public MetricReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Metric> read(TwilioRestClient client) {
        return new ResourceSet<Metric>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Metric> firstPage(TwilioRestClient client) {
        String path = "/v1/Voice/{CallSid}/Metrics";
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Metric> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Metric read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("metrics", response.getContent(), Metric.class, client.getObjectMapper());
    }

    @Override
    public Page<Metric> previousPage(Page<Metric> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Metric> nextPage(Page<Metric> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.INSIGHTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Metric> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.edge != null) {
            request.addQueryParam("Edge", this.edge.toString());
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

