/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.Conference;

public class ConferenceFetcher
extends Fetcher<Conference> {
    private String pathConferenceSid;

    public ConferenceFetcher(String pathConferenceSid) {
        this.pathConferenceSid = pathConferenceSid;
    }

    @Override
    public Conference fetch(TwilioRestClient client) {
        String path = "/v1/Conferences/{ConferenceSid}";
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Conference.fromJson(response.getStream(), client.getObjectMapper());
    }
}

