/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.plugin;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.plugin.PluginVersions;

public class PluginVersionsReader
extends Reader<PluginVersions> {
    private String pathPluginSid;
    private String flexMetadata;
    private Integer pageSize;

    public PluginVersionsReader(String pathPluginSid) {
        this.pathPluginSid = pathPluginSid;
    }

    public PluginVersionsReader setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    public PluginVersionsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<PluginVersions> read(TwilioRestClient client) {
        return new ResourceSet<PluginVersions>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PluginVersions> firstPage(TwilioRestClient client) {
        String path = "/v1/PluginService/Plugins/{PluginSid}/Versions";
        path = path.replace("{PluginSid}", this.pathPluginSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<PluginVersions> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PluginVersions read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("plugin_versions", response.getContent(), PluginVersions.class, client.getObjectMapper());
    }

    @Override
    public Page<PluginVersions> previousPage(Page<PluginVersions> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PluginVersions> nextPage(Page<PluginVersions> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PluginVersions> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

