/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesCategory;

public class InsightsQuestionnairesCategoryCreator
extends Creator<InsightsQuestionnairesCategory> {
    private String name;
    private String authorization;

    public InsightsQuestionnairesCategoryCreator(String name) {
        this.name = name;
    }

    public InsightsQuestionnairesCategoryCreator setName(String name) {
        this.name = name;
        return this;
    }

    public InsightsQuestionnairesCategoryCreator setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public InsightsQuestionnairesCategory create(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Categories";
        path = path.replace("{Name}", this.name.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsQuestionnairesCategory creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InsightsQuestionnairesCategory.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.name != null) {
            request.addPostParam("Name", this.name);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

