/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.FlexFlow;

public class FlexFlowFetcher
extends Fetcher<FlexFlow> {
    private String pathSid;

    public FlexFlowFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public FlexFlow fetch(TwilioRestClient client) {
        String path = "/v1/FlexFlows/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlexFlow fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlexFlow.fromJson(response.getStream(), client.getObjectMapper());
    }
}

