/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.SubscriptionCreator;
import com.twilio.rest.events.v1.SubscriptionDeleter;
import com.twilio.rest.events.v1.SubscriptionFetcher;
import com.twilio.rest.events.v1.SubscriptionReader;
import com.twilio.rest.events.v1.SubscriptionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Subscription
extends Resource {
    private static final long serialVersionUID = 198248500185102L;
    private final String accountSid;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String description;
    private final String sinkSid;
    private final URI url;
    private final Map<String, String> links;

    public static SubscriptionCreator creator(String description, String sinkSid, List<Map<String, Object>> types) {
        return new SubscriptionCreator(description, sinkSid, types);
    }

    public static SubscriptionDeleter deleter(String pathSid) {
        return new SubscriptionDeleter(pathSid);
    }

    public static SubscriptionFetcher fetcher(String pathSid) {
        return new SubscriptionFetcher(pathSid);
    }

    public static SubscriptionReader reader() {
        return new SubscriptionReader();
    }

    public static SubscriptionUpdater updater(String pathSid) {
        return new SubscriptionUpdater(pathSid);
    }

    public static Subscription fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Subscription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Subscription fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Subscription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Subscription(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="description") String description, @JsonProperty(value="sink_sid") String sinkSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.description = description;
        this.sinkSid = sinkSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getSinkSid() {
        return this.sinkSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription other = (Subscription)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.description, other.description) && Objects.equals(this.sinkSid, other.sinkSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.dateCreated, this.dateUpdated, this.description, this.sinkSid, this.url, this.links);
    }

    public String toString() {
        return "Subscription(accountSid=" + this.getAccountSid() + ", sid=" + this.getSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", description=" + this.getDescription() + ", sinkSid=" + this.getSinkSid() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

