/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.Sink;

public class SinkReader
extends Reader<Sink> {
    private Boolean inUse;
    private String status;
    private Integer pageSize;

    public SinkReader setInUse(Boolean inUse) {
        this.inUse = inUse;
        return this;
    }

    public SinkReader setStatus(String status) {
        this.status = status;
        return this;
    }

    public SinkReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Sink> read(TwilioRestClient client) {
        return new ResourceSet<Sink>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Sink> firstPage(TwilioRestClient client) {
        String path = "/v1/Sinks";
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Sink> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sink read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("sinks", response.getContent(), Sink.class, client.getObjectMapper());
    }

    @Override
    public Page<Sink> previousPage(Page<Sink> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sink> nextPage(Page<Sink> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sink> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.inUse != null) {
            request.addQueryParam("InUse", this.inUse.toString());
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

