/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.user;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.user.UserConversation;
import java.time.ZonedDateTime;

public class UserConversationUpdater
extends Updater<UserConversation> {
    private String pathChatServiceSid;
    private String pathUserSid;
    private String pathConversationSid;
    private UserConversation.NotificationLevel notificationLevel;
    private ZonedDateTime lastReadTimestamp;
    private Integer lastReadMessageIndex;

    public UserConversationUpdater(String pathChatServiceSid, String pathUserSid, String pathConversationSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathUserSid = pathUserSid;
        this.pathConversationSid = pathConversationSid;
    }

    public UserConversationUpdater setNotificationLevel(UserConversation.NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    public UserConversationUpdater setLastReadTimestamp(ZonedDateTime lastReadTimestamp) {
        this.lastReadTimestamp = lastReadTimestamp;
        return this;
    }

    public UserConversationUpdater setLastReadMessageIndex(Integer lastReadMessageIndex) {
        this.lastReadMessageIndex = lastReadMessageIndex;
        return this;
    }

    @Override
    public UserConversation update(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Users/{UserSid}/Conversations/{ConversationSid}";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{UserSid}", this.pathUserSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UserConversation update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return UserConversation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.notificationLevel != null) {
            request.addPostParam("NotificationLevel", this.notificationLevel.toString());
        }
        if (this.lastReadTimestamp != null) {
            request.addPostParam("LastReadTimestamp", this.lastReadTimestamp.toInstant().toString());
        }
        if (this.lastReadMessageIndex != null) {
            request.addPostParam("LastReadMessageIndex", this.lastReadMessageIndex.toString());
        }
    }
}

