/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.Webhook;
import java.util.List;

public class WebhookCreator
extends Creator<Webhook> {
    private String pathChatServiceSid;
    private String pathConversationSid;
    private Webhook.Target target;
    private String configurationUrl;
    private Webhook.Method configurationMethod;
    private List<String> configurationFilters;
    private List<String> configurationTriggers;
    private String configurationFlowSid;
    private Integer configurationReplayAfter;

    public WebhookCreator(String pathChatServiceSid, String pathConversationSid, Webhook.Target target) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
        this.target = target;
    }

    public WebhookCreator setTarget(Webhook.Target target) {
        this.target = target;
        return this;
    }

    public WebhookCreator setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public WebhookCreator setConfigurationMethod(Webhook.Method configurationMethod) {
        this.configurationMethod = configurationMethod;
        return this;
    }

    public WebhookCreator setConfigurationFilters(List<String> configurationFilters) {
        this.configurationFilters = configurationFilters;
        return this;
    }

    public WebhookCreator setConfigurationFilters(String configurationFilters) {
        return this.setConfigurationFilters(Promoter.listOfOne(configurationFilters));
    }

    public WebhookCreator setConfigurationTriggers(List<String> configurationTriggers) {
        this.configurationTriggers = configurationTriggers;
        return this;
    }

    public WebhookCreator setConfigurationTriggers(String configurationTriggers) {
        return this.setConfigurationTriggers(Promoter.listOfOne(configurationTriggers));
    }

    public WebhookCreator setConfigurationFlowSid(String configurationFlowSid) {
        this.configurationFlowSid = configurationFlowSid;
        return this;
    }

    public WebhookCreator setConfigurationReplayAfter(Integer configurationReplayAfter) {
        this.configurationReplayAfter = configurationReplayAfter;
        return this;
    }

    @Override
    public Webhook create(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{ConversationSid}/Webhooks";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        path = path.replace("{Target}", this.target.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.target != null) {
            request.addPostParam("Target", this.target.toString());
        }
        if (this.configurationUrl != null) {
            request.addPostParam("Configuration.Url", this.configurationUrl);
        }
        if (this.configurationMethod != null) {
            request.addPostParam("Configuration.Method", this.configurationMethod.toString());
        }
        if (this.configurationFilters != null) {
            for (String prop : this.configurationFilters) {
                request.addPostParam("Configuration.Filters", prop);
            }
        }
        if (this.configurationTriggers != null) {
            for (String prop : this.configurationTriggers) {
                request.addPostParam("Configuration.Triggers", prop);
            }
        }
        if (this.configurationFlowSid != null) {
            request.addPostParam("Configuration.FlowSid", this.configurationFlowSid);
        }
        if (this.configurationReplayAfter != null) {
            request.addPostParam("Configuration.ReplayAfter", this.configurationReplayAfter.toString());
        }
    }
}

