/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.Configuration;

public class ConfigurationUpdater
extends Updater<Configuration> {
    private String pathChatServiceSid;
    private String defaultConversationCreatorRoleSid;
    private String defaultConversationRoleSid;
    private String defaultChatServiceRoleSid;
    private Boolean reachabilityEnabled;

    public ConfigurationUpdater(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public ConfigurationUpdater setDefaultConversationCreatorRoleSid(String defaultConversationCreatorRoleSid) {
        this.defaultConversationCreatorRoleSid = defaultConversationCreatorRoleSid;
        return this;
    }

    public ConfigurationUpdater setDefaultConversationRoleSid(String defaultConversationRoleSid) {
        this.defaultConversationRoleSid = defaultConversationRoleSid;
        return this;
    }

    public ConfigurationUpdater setDefaultChatServiceRoleSid(String defaultChatServiceRoleSid) {
        this.defaultChatServiceRoleSid = defaultChatServiceRoleSid;
        return this;
    }

    public ConfigurationUpdater setReachabilityEnabled(Boolean reachabilityEnabled) {
        this.reachabilityEnabled = reachabilityEnabled;
        return this;
    }

    @Override
    public Configuration update(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Configuration";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Configuration update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Configuration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.defaultConversationCreatorRoleSid != null) {
            request.addPostParam("DefaultConversationCreatorRoleSid", this.defaultConversationCreatorRoleSid);
        }
        if (this.defaultConversationRoleSid != null) {
            request.addPostParam("DefaultConversationRoleSid", this.defaultConversationRoleSid);
        }
        if (this.defaultChatServiceRoleSid != null) {
            request.addPostParam("DefaultChatServiceRoleSid", this.defaultChatServiceRoleSid);
        }
        if (this.reachabilityEnabled != null) {
            request.addPostParam("ReachabilityEnabled", this.reachabilityEnabled.toString());
        }
    }
}

