/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.Configuration;

public class ConfigurationUpdater
extends Updater<Configuration> {
    private String defaultChatServiceSid;
    private String defaultMessagingServiceSid;
    private String defaultInactiveTimer;
    private String defaultClosedTimer;

    public ConfigurationUpdater setDefaultChatServiceSid(String defaultChatServiceSid) {
        this.defaultChatServiceSid = defaultChatServiceSid;
        return this;
    }

    public ConfigurationUpdater setDefaultMessagingServiceSid(String defaultMessagingServiceSid) {
        this.defaultMessagingServiceSid = defaultMessagingServiceSid;
        return this;
    }

    public ConfigurationUpdater setDefaultInactiveTimer(String defaultInactiveTimer) {
        this.defaultInactiveTimer = defaultInactiveTimer;
        return this;
    }

    public ConfigurationUpdater setDefaultClosedTimer(String defaultClosedTimer) {
        this.defaultClosedTimer = defaultClosedTimer;
        return this;
    }

    @Override
    public Configuration update(TwilioRestClient client) {
        String path = "/v1/Configuration";
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Configuration update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Configuration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.defaultChatServiceSid != null) {
            request.addPostParam("DefaultChatServiceSid", this.defaultChatServiceSid);
        }
        if (this.defaultMessagingServiceSid != null) {
            request.addPostParam("DefaultMessagingServiceSid", this.defaultMessagingServiceSid);
        }
        if (this.defaultInactiveTimer != null) {
            request.addPostParam("DefaultInactiveTimer", this.defaultInactiveTimer);
        }
        if (this.defaultClosedTimer != null) {
            request.addPostParam("DefaultClosedTimer", this.defaultClosedTimer);
        }
    }
}

