/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.AddressConfiguration;

public class AddressConfigurationReader
extends Reader<AddressConfiguration> {
    private String type;
    private Integer pageSize;

    public AddressConfigurationReader setType(String type) {
        this.type = type;
        return this;
    }

    public AddressConfigurationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<AddressConfiguration> read(TwilioRestClient client) {
        return new ResourceSet<AddressConfiguration>(this, client, this.firstPage(client));
    }

    @Override
    public Page<AddressConfiguration> firstPage(TwilioRestClient client) {
        String path = "/v1/Configuration/Addresses";
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<AddressConfiguration> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddressConfiguration read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("address_configurations", response.getContent(), AddressConfiguration.class, client.getObjectMapper());
    }

    @Override
    public Page<AddressConfiguration> previousPage(Page<AddressConfiguration> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AddressConfiguration> nextPage(Page<AddressConfiguration> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AddressConfiguration> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.type != null) {
            request.addQueryParam("Type", this.type);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

