/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.User;

public class UserCreator
extends Creator<User> {
    private String pathServiceSid;
    private String identity;
    private User.WebhookEnabledType xTwilioWebhookEnabled;
    private String roleSid;
    private String attributes;
    private String friendlyName;

    public UserCreator(String pathServiceSid, String identity) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
    }

    public UserCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public UserCreator setXTwilioWebhookEnabled(User.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public UserCreator setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public UserCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public UserCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public User create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Users";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.identity.toString());
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

