/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.Trigger;

public class TriggerReader
extends Reader<Trigger> {
    private String pathAccountSid;
    private Trigger.Recurring recurring;
    private Trigger.TriggerField triggerBy;
    private Trigger.UsageCategory usageCategory;
    private Integer pageSize;

    public TriggerReader() {
    }

    public TriggerReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public TriggerReader setRecurring(Trigger.Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    public TriggerReader setTriggerBy(Trigger.TriggerField triggerBy) {
        this.triggerBy = triggerBy;
        return this;
    }

    public TriggerReader setUsageCategory(Trigger.UsageCategory usageCategory) {
        this.usageCategory = usageCategory;
        return this;
    }

    public TriggerReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Trigger> read(TwilioRestClient client) {
        return new ResourceSet<Trigger>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Trigger> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Usage/Triggers.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Trigger> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trigger read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_triggers", response.getContent(), Trigger.class, client.getObjectMapper());
    }

    @Override
    public Page<Trigger> previousPage(Page<Trigger> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trigger> nextPage(Page<Trigger> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trigger> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.recurring != null) {
            request.addQueryParam("Recurring", this.recurring.toString());
        }
        if (this.triggerBy != null) {
            request.addQueryParam("TriggerBy", this.triggerBy.toString());
        }
        if (this.usageCategory != null) {
            request.addQueryParam("UsageCategory", this.usageCategory.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

