/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.IpAccessControlListMapping;

public class IpAccessControlListMappingCreator
extends Creator<IpAccessControlListMapping> {
    private String pathDomainSid;
    private String ipAccessControlListSid;
    private String pathAccountSid;

    public IpAccessControlListMappingCreator(String pathDomainSid, String ipAccessControlListSid) {
        this.pathDomainSid = pathDomainSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    public IpAccessControlListMappingCreator(String pathAccountSid, String pathDomainSid, String ipAccessControlListSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathDomainSid = pathDomainSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
    }

    public IpAccessControlListMappingCreator setIpAccessControlListSid(String ipAccessControlListSid) {
        this.ipAccessControlListSid = ipAccessControlListSid;
        return this;
    }

    @Override
    public IpAccessControlListMapping create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/IpAccessControlListMappings.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{DomainSid}", this.pathDomainSid.toString());
        path = path.replace("{IpAccessControlListSid}", this.ipAccessControlListSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlListMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return IpAccessControlListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ipAccessControlListSid != null) {
            request.addPostParam("IpAccessControlListSid", this.ipAccessControlListSid);
        }
    }
}

