/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.TollFree;
import com.twilio.type.PhoneNumber;

public class TollFreeReader
extends Reader<TollFree> {
    private String pathAccountSid;
    private Boolean beta;
    private String friendlyName;
    private PhoneNumber phoneNumber;
    private String origin;
    private Integer pageSize;

    public TollFreeReader() {
    }

    public TollFreeReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public TollFreeReader setBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public TollFreeReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TollFreeReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public TollFreeReader setPhoneNumber(String phoneNumber) {
        return this.setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    public TollFreeReader setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public TollFreeReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<TollFree> read(TwilioRestClient client) {
        return new ResourceSet<TollFree>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TollFree> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/TollFree.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<TollFree> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TollFree read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("incoming_phone_numbers", response.getContent(), TollFree.class, client.getObjectMapper());
    }

    @Override
    public Page<TollFree> previousPage(Page<TollFree> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TollFree> nextPage(Page<TollFree> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TollFree> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.origin != null) {
            request.addQueryParam("Origin", this.origin);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

