/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.EventReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
extends Resource {
    private static final long serialVersionUID = 87960678380335L;
    private final Map<String, Object> request;
    private final Map<String, Object> response;

    public static EventReader reader(String pathCallSid) {
        return new EventReader(pathCallSid);
    }

    public static EventReader reader(String pathAccountSid, String pathCallSid) {
        return new EventReader(pathAccountSid, pathCallSid);
    }

    public static Event fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Event fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Event(@JsonProperty(value="request") Map<String, Object> request, @JsonProperty(value="response") Map<String, Object> response) {
        this.request = request;
        this.response = response;
    }

    public final Map<String, Object> getRequest() {
        return this.request;
    }

    public final Map<String, Object> getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.request, other.request) && Objects.equals(this.response, other.response);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.response);
    }

    public String toString() {
        return "Event(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
    }
}

